/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.bean.HttpProxySettings;
import oracle.install.ivw.common.bean.MyOracleSupportSettings;
import oracle.install.ivw.common.resource.AutoUpdatesErrorCode;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.autoupdates.AutoUpdatesInstallConstants;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.PlatformInfo;

public class UpdatesListValidator
implements CompositeValidator {
    StatusMessages<ValidationStatusMessage> messages;

    public void validate(FlowContext flowContext) throws ValidationException {
        if (this.messages == null) {
            this.messages = new StatusMessages();
        } else {
            this.messages.clear();
        }
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)((Object)flowContext.getBean(AutoUpdatesInstallSettings.class));
        if (autoBean.getDownloadType() == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD) {
            this.messages.addAll(this.validateDownloadLocation(autoBean.getPatchDownloadLocation()));
            this.messages.addAll(this.validateForFreeSpaceInDownloadLoc(autoBean.getPatchDownloadLocation(), autoBean.getMyoracleSupportDetails(), autoBean.getHttpProxySettings()));
        }
        if (autoBean.getDownloadType() == PatchDownloadType.OFFLINE_UPDATES) {
            this.messages.addAll(this.validateDownloadLocation(autoBean.getPatchDownloadLocation(), true));
        }
    }

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.messages;
    }

    public StatusMessages<ValidationStatusMessage> validateDownloadLocation(String downloadLocation, boolean isOfflineMode) {
        StatusMessages msgs = new StatusMessages();
        if (isOfflineMode) {
            UpdateManager updManager;
            List<String> bugNumbers;
            String updatesDir = downloadLocation + File.separator + "LatestUpdates";
            File oneOffsDir = new File(updatesDir, "OneOffs");
            List<Object> oneOffUpdatesList = new ArrayList();
            if (oneOffsDir != null && oneOffsDir.exists()) {
                oneOffUpdatesList = Arrays.asList(oneOffsDir.list());
            }
            List<Object> installUpdatesList = new ArrayList();
            File installUpdatesDir = new File(updatesDir, "Shiphome");
            if (installUpdatesDir != null && installUpdatesDir.exists()) {
                installUpdatesList = Arrays.asList(installUpdatesDir.list());
            }
            List<Object> cpuUpdatesList = new ArrayList();
            File cpusDir = new File(updatesDir, "CPUs");
            if (cpusDir != null && cpusDir.exists()) {
                cpuUpdatesList = Arrays.asList(cpusDir.list());
            }
            List<Object> ouiUpdatesList = new ArrayList();
            File ouiUpdatesDir = new File(updatesDir, AutoUpdatesInstallConstants.OUI_UPDATES_DIR);
            if (ouiUpdatesDir != null && ouiUpdatesDir.exists()) {
                ouiUpdatesList = Arrays.asList(ouiUpdatesDir.list());
            }
            List<Object> opatchUpdatesList = new ArrayList();
            File opatchUpdatesDir = new File(updatesDir, AutoUpdatesInstallConstants.OPATCH_UPDATES_DIR);
            if (opatchUpdatesDir != null && opatchUpdatesDir.exists()) {
                opatchUpdatesList = Arrays.asList(opatchUpdatesDir.list());
            }
            if ((bugNumbers = (updManager = UpdateManager.getInstance()).getListOfBugNumbers(updManager.getListOfUpdatesSelected())) != null && bugNumbers.size() > 0) {
                for (String bug : bugNumbers) {
                    if (oneOffUpdatesList.contains(bug) || cpuUpdatesList.contains(bug) || ouiUpdatesList.contains(bug) || installUpdatesList.contains(bug) || opatchUpdatesList.contains(bug)) continue;
                    msgs.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.PATCHDOWNLOAD_LOCATION_INVALID, new Object[0]));
                }
            }
        } else {
            msgs.addAll(this.validateDownloadLocation(downloadLocation));
        }
        return msgs;
    }

    public StatusMessages<ValidationStatusMessage> validateDownloadLocation(String downloadLocation) {
        StatusMessages msgs = new StatusMessages();
        Application app = Application.getInstance();
        Resource res = app.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
        String locationLabel = res.getString("DOWNLOAD_LOC", "download location", new Object[0]);
        try {
            BaseInstallLocationValidator.validateLocation(downloadLocation, locationLabel);
            String spaceFound = null;
            spaceFound = GenericValidation.validateBadCharGetString(" ", downloadLocation);
            if (PlatformInfo.getInstance().isUnix() && spaceFound != null) {
                Application application = Application.getInstance();
                Resource resource = application.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
                String label = resource.getString("DOWNLOAD_LOC", "download location", new Object[0]);
                throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_SPACECHAR_ERR, new Object[]{label});
            }
            File metadataLoc = new File(downloadLocation, "metadata");
            File updatesLoc = new File(downloadLocation, "LatestUpdates");
            if (metadataLoc.exists() && updatesLoc.exists()) {
                msgs.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.EXISTENT_UPDATES_LOCATION_PROVIDED, new Object[0]));
            }
        }
        catch (ValidationException e) {
            msgs.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
        }
        return msgs;
    }

    public StatusMessages<ValidationStatusMessage> validateForFreeSpaceInDownloadLoc(String downloadLoc, MyOracleSupportSettings details, HttpProxySettings proxyDet) {
        Integer freeSpaceInKB;
        Long longFreeSpaceInKB;
        StatusMessages msgs = new StatusMessages();
        UpdateManager updateManager = UpdateManager.getInstance();
        long downloadSize = updateManager.getTotalDownloadSizeForAllPatches(details, proxyDet);
        long downloadSizeInKB = downloadSize / 1024L;
        long downloadSizeInMB = downloadSize / 0x100000L;
        String localDirPath = GenericValidation.getLastExistingParent(downloadLoc);
        if (localDirPath != null && localDirPath.length() > 0 && (longFreeSpaceInKB = new Long((freeSpaceInKB = FileSystemInfo.getInstance().getFreeSpace(localDirPath, false)).intValue())) < downloadSizeInKB) {
            msgs.add((StatusMessage)new ValidationStatusMessage((ErrorCode)AutoUpdatesErrorCode.INSUFFICIENT_SPACE_IN_DOWNLOAD_LOC, new Object[0]));
        }
        return msgs;
    }
}

